<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="Empresa líder en verificación y seguridad dentro del sector aeronáutico en EE.UU. Combatiendo el fraude y garantizando transparencia en cada transacción.">
  <meta property="og:title" content="SCAM INVESTIGATIONS AERONAUTICS">
  <meta property="og:description" content="Empresa líder en verificación y seguridad dentro del sector aeronáutico en EE.UU. Combatiendo el fraude y garantizando transparencia en cada transacción.">
  <meta property="og:image" content="himg/logo3.png"> <!-- usa URL absoluta -->
  <meta property="og:type" content="website">

  <link
    href="https://cdn.jsdelivr.net/npm/remixicon@4.3.0/fonts/remixicon.css"
    rel="stylesheet" />
  <link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
  <link rel="stylesheet" href="styles.css" />
  <link rel="stylesheet" href="estilospersonales.css" />
  <link rel="icon" href="img/logo3.png" type="image/png">
  <!-- En la sección <head> de tu página -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <title>SCAM INVESTIGATIONS AERONAUTICS</title>

</head>

<body>
  <div class="container">
    <div class="main-wrapper">
      <nav>
        <div class="nav__header">
          <div class="nav__logo">
            <a href="#" class="logo">
              <img src="img/logo3.png" alt="Logo de la empresa" class="logo-img desktop-logo">
              <img src="img/logo4.png" alt="Logo de la empresa" class="logo-img mobile-logo">
            </a>
            <div class="language-selector">
              <select id="languageSelect" class="select-lang">
                <option value="es" data-flag="https://flagcdn.com/w40/es.png">Español</option>
                <option value="en" data-flag="https://flagcdn.com/w40/gb.png">English</option>
              </select>
              <div class="selected-option">
                <img class="flag-icon" src="https://flagcdn.com/w40/es.png" alt="Flag" width="20">
                <span class="selected-text">Español</span>
                <span class="arrow">▼</span>
              </div>
            </div>

          </div>
          <div class="nav__menu__btn" id="menu-btn">
            <i class="ri-menu-line"></i>
          </div>
        </div>
        <ul class="nav__links" id="nav-links">
          <li><a href="#home" id="nav-home">INICIO</a></li>
          <li><a href="#about" id="nav-about">¿QUIÉNES SOMOS?</a></li>
          <li><a href="#vision" id="nav-vision">NUESTRA VISIÓN</a></li>
          <li><a href="#comentarios" id="nav-comentarios">COMENTARIOS</a></li>
          <li><a href="#contact" id="nav-contact">CONTACTOS</a></li>
          <li><a href="#" id="nav-book-trip">BOOK TRIP</a></li>
        </ul>
        <!-- Selector de Idioma -->

      </nav>

      <header id="home">
        <div class="particles" id="particles"></div>
        <div class="header__container">
          <div class="header__content">
            <p id="mascerca">MÁS CERCA DE TÍ !!</p>
            <h1>SCAM INVESTIGATIONS AERONAUTICS</h1>
            <div class="header__btns">
              <button class="modern-btn" id="quien">¿QUIÉNES SOMOS?</button>
            </div>
          </div>
          <div class="header__image">
            <img src="assets/header.png" alt="Scam Investigations Aeronautics">
          </div>
        </div>
      </header>
      <section class="about__container" id="about">
        <div class="trust-header">
          <p class="subheader" id="aboutwho">¿QUIÉNES SOMOS?</p>
          <h2 class="section__header">SCAM INVESTIGATIONS AERONAUTICS</h2>
          <p class="section__description" id="aboutdesc">
            Empresa líder en verificación y seguridad dentro del sector aeronáutico en EE.UU.
            Combatiendo el fraude y garantizando transparencia en cada transacción.
            <br>
          </p>
          <button class="modern-btn" id="openModalBtn">
            <p id="leer">Leer más</p> <span>+</span>
          </button>

        </div>
        <!-- Modal -->
        <div class="modal-overlay" id="modalOverlay">
          <div class="modal-container">
            <div class="modal-header">
              <h3 id="modalmoreabout">Más sobre nosotros</h3>
              <button class="close-modal" id="closeModalBtn">&times;</button>
            </div>
            <div class="modal-contentDatos">
              <p style="text-align: justify;" id="texto1">
                En <b>SCAM INVESTIGATIONS AERONAUTICS</b>, somos una
                empresa especializada en proporcionar información verificada,
                confiable y segura sobre empresas aeronáuticas en los Estados
                Unidos. Nos dedicamos a investigar exhaustivamente las
                oportunidades de negocio dentro del sector aeronáutico, ofreciendo
                referencias precisas para que nuestros clientes puedan tomar
                decisiones acertadas sobre compra y venta dentro del sector.
                Lo que realmente nos diferencia es nuestra capacidad para analizar
                y detectar estafas en
                el entorno aeronáutico. Nuestro equipo no solo investiga casos
                sospechosos de
                fraude,
                sino que también actúa como intermediario entre las partes
                involucradas, buscando siempre
                una resolución equitativa. En los casos donde no se logre una
                solución satisfactoria,
                tomamos acciones públicas a través de redes sociales y otras
                plataformas para exponer
                las estafas, proteger a otros posibles afectados y garantizar la
                transparencia en el sector.
              </p>
              <p id="featuredservices"><b>SERVICIOS DESTACADOS:</b></p>
              <ul>
                <li id="l1">✔ <b>Auditorías de seguridad aeroportuaria</b></li>
                <li id="l2">✔ <b>Investigación de fraudes en transacciones aeronáuticas</b></li>
                <li id="l3">✔ <b>Certificación de proveedores del sector</b></li>
                <li id="l4">✔ <b>Consultoría en cumplimiento normativo FAA</b></li>
              </ul>
            </div>
          </div>
        </div>
        <div class="about__grid">
          <!-- Tarjeta 1 -->
          <div class="about__card">
            <div class="card__header">
              <span class="number">01</span>
              <h3 id="investigationheader">INVESTIGACIÓN Y VERIFICACIÓN</h3>
            </div>
            <div class="card__content">
              <p class="card__text" id="card1text">
                Verificamos antecedentes, historial y reputación de empresas aeronáuticas para garantizar negocios seguros.
              </p>
              <button class="read-more__btn modern-btn" data-card="1">
                <p id="leer1">Leer más</p> <span>+</span>
              </button>
              <div class="expandable__content" id="card-1-details">
                <ul class="features__list">
                  <li id="card1list1">✔ Investigación de credibilidad</li>
                  <li id="card1list2">✔ Verificación de transacciones</li>
                  <li id="card1list3">✔ Estudios de mercado detallados</li>
                  <li id="card1list4">✔ Análisis de riesgo empresarial</li>
                </ul>
              </div>
            </div>
          </div>

          <!-- Tarjeta 2 -->
          <div class="about__card">
            <div class="card__header">
              <span class="number">02</span>
              <h3 id="fraudanalysisheader">ANÁLISIS DE CASOS DE ESTAFA</h3>
            </div>
            <div class="card__content">
              <p class="card__text" id="card2text">
                Investigación exhaustiva de fraudes y mediación profesional para proteger sus intereses.
              </p>
              <button class="read-more__btn modern-btn" data-card="2">
                <p id="leer2">Leer más</p> <span>+</span>
              </button>
              <div class="expandable__content" id="card-2-details">
                <ul class="features__list">
                  <li id="card2list1">✔ Investigación forense de casos</li>
                  <li id="card2list2">✔ Intermediación en disputas</li>
                  <li id="card2list3">✔ Acciones públicas contra fraudes</li>
                  <li id="card2list4">✔ Alertas tempranas de riesgo</li>
                </ul>
              </div>
            </div>
          </div>

          <!-- Tarjeta 3 -->
          <div class="about__card">
            <div class="card__header">
              <span class="number">03</span>
              <h3 id="consultingheader">CONSULTORÍA ESPECIALIZADA</h3>
            </div>
            <div class="card__content">
              <p class="card__text" id="card3text">
                Soluciones legales y estratégicas para problemas, conflictos legales en el sector aeronáutico.
              </p>
              <button class="read-more__btn modern-btn" data-card="3">
                <p id="leer3">Leer más</p> <span>+</span>
              </button>
              <div class="expandable__content" id="card-3-details">
                <ul class="features__list">
                  <li id="card3list1">✔ Mediación profesional</li>
                  <li id="card3list2">✔ Resolución de disputas</li>
                  <li id="card3list3">✔ Asesoría legal especializada</li>
                  <li id="card3list4">✔ Estrategias preventivas</li>
                </ul>
              </div>
            </div>
          </div>

        </div>

        <!-- Galería visual -->
        <div class="about__gallery">
          <img src="img/img1_1.jpg" alt="Equipo investigador trabajando" loading="lazy">
          <img src="img/img1_2.jpg" alt="Reunión de mediación" loading="lazy">
          <img src="img/img1_3.jpg" alt="Análisis de documentos" loading="lazy">
        </div>
      </section>
      <section class="vision-section" id="vision">
        <div class="vision-content">
          <h2 class="values-title" id="visionTitle">NUESTRA VISIÓN</h2>
          <p style="text-align: justify;" id="visionText">
            Proteger a nuestros clientes de fraudes y estafas dentro de la
            industria aeronáutica, asegurando que cada transacción sea
            legítima, transparente y segura. Nos comprometemos a ofrecer las
            mejores referencias sobre empresas aeronáuticas y a actuar de
            manera proactiva para resolver cualquier conflicto que pueda surgir
            durante el proceso de compra, venta o asociación.
          </p>
          <h2 class="values-title" id="valuesTitle">NUESTROS VALORES</h2>
          <div class="scroll-indicator">
            <span class="arrow">↓</span>
            <span class="pulse-animation"></span>
          </div>

          <div class="vision-features">
            <div class="feature-card">
              <svg viewBox="0 0 24 24" width="48" height="48">
                <path fill="#004080" d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11V11.99z" />
              </svg>
              <h3 class="feature-title" id="value1Title">INTEGRIDAD</h3>
              <p class="feature-text" id="value1Text">
                Siempre actuamos con ética y honestidad,
                protegiendo los intereses de nuestros clientes en todo
                momento
              </p>
            </div>

            <div class="feature-card">
              <svg viewBox="0 0 24 24" width="48" height="48">
                <path fill="#004080" d="M11 14v-3h2v3h5v2h-5v3l-4-4 4-4v3h5v-2h-5zm-8 0h3v2H3v-2zm14-5h3v2h-3V9zM3 9h3v2H3V9zm14-5h3v2h-3V4zM3 4h3v2H3V4z" />
              </svg>
              <h3 class="feature-title" id="value2Title">CONFIANZA</h3>
              <p class="feature-text" id="value2Text">
                Nos dedicamos a proporcionar la información más
                precisa y confiable, asegurando que nuestros clientes tomen
                decisiones informadas.
              </p>
            </div>

            <div class="feature-card">
              <svg viewBox="0 0 24 24" width="48" height="48">
                <path fill="#004080" d="M20.56 3.91c.59.59.59 1.54 0 2.12l-6.36 6.36 1.41 1.41 3.54-3.54 1.41 1.41-5.66 5.66-3.54-3.54-4.24 4.24-1.41-1.41 4.24-4.24L3 10.22l1.41-1.41 3.54 3.54 1.41-1.41-6.36-6.36a1.49 1.49 0 0 1 0-2.12c.59-.58 1.54-.58 2.12 0l16.97 16.97z" />
              </svg>
              <h3 class="feature-title" id="value3Title">PROACTIVIDAD</h3>
              <p class="feature-text" id="value3Text">
                Nos adelantamos a los posibles riesgos,
                tomando medidas preventivas ante cualquier indicio de fraude.
              </p>
            </div>

            <div class="feature-card">
              <svg viewBox="0 0 24 24" width="48" height="48">
                <path fill="#004080" d="M15.5 14h-.79l-.28-.27a6.5 6.5 0 0 0 1.48-5.34c-.47-2.78-2.79-5-5.59-5.34a6.505 6.505 0 0 0-7.27 7.27c.34 2.8 2.56 5.12 5.34 5.59a6.5 6.5 0 0 0 5.34-1.48l.27.28v.79l4.25 4.25c.41.41 1.08.41 1.49 0 .41-.41.41-1.08 0-1.49L15.5 14zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14zm-2-5h4v2h-4V9z" />
              </svg>
              <h3 class="feature-title" id="value4Title">TRANSPARENCIA</h3>
              <p class="feature-text" id="value4Text">
                Nos aseguramos de que todo el proceso de
                investigación y mediación se realice de manera abierta y clara,
                con el fin de que nuestros clientes estén informados en todo
                momento.
              </p>
            </div>
          </div>
        </div>
        <div class="vision-gallery">
          <div class="gallery-item">
            <img src="img/integridad_1.jpg" alt="Espacio lounge moderno" loading="lazy">
            <div class="image-overlay"></div>
          </div>
          <div class="gallery-item">
            <img src="img/confianza_1.jpg" alt="Ambiente acogedor" loading="lazy">
            <div class="image-overlay"></div>
          </div>
        </div>
      </section>
      <section class="modern-section" id="about">
        <div class="section-header">
          <h2 id="aboutTitle">¿POR QUÉ ELEGIR SCAM INVESTIGATION AERONAUTICS?</h2>
          <div class="animated-divider"></div>
          <p class="section-description" id="aboutDesc">
            Si una resolución amistosa no es posible, tomamos medidas públicas en redes sociales para alertar sobre fraudes.
          </p>
        </div>

        <div class="dynamic-cards">
          <!-- Tarjeta 1 -->
          <div class="aero-card">
            <div class="card-image-container">
              <img src="img/inv_1.jpg" alt="Investigación" loading="lazy" />
              <div class="hover-beam"></div>
            </div>
            <div class="card-content">
              <div class="card-icon">✈️</div>
              <h3 id="card1Title">INVESTIGACIÓN EXHAUSTIVA</h3>
              <p id="card1Text">Análisis forense de transacciones aeronáuticas con tecnología de vanguardia.</p>
            </div>
            <div class="card-glare"></div>
          </div>

          <!-- Tarjeta 2 -->
          <div class="aero-card">
            <div class="card-image-container">
              <img src="img/frau_1.jpg" alt="Protección" loading="lazy" />
              <div class="hover-beam"></div>
            </div>
            <div class="card-content">
              <div class="card-icon">🛡️</div>
              <h3 id="card2Title">PROTECCIÓN CONTRA FRAUDES</h3>
              <p id="card2Text">Sistemas predictivos para identificar patrones de fraude antes que ocurran.</p>
            </div>
            <div class="card-glare"></div>
          </div>

          <!-- Tarjeta 3 -->
          <div class="aero-card">
            <div class="card-image-container">
              <img src="img/ce_1.jpg" alt="Mediación" loading="lazy" />
              <div class="hover-beam"></div>
            </div>
            <div class="card-content">
              <div class="card-icon">⚖️</div>
              <h3 id="card3Title">INTERMEDIACIÓN PROFESIONAL</h3>
              <p id="card3Text">Protocolos de resolución de conflictos avalados por la FAA.</p>
            </div>
            <div class="card-glare"></div>
          </div>
        </div>
      </section>

      <section class="trust-section">
        <div class="trust-header">
          <h2 id="trust_title">¿POR QUÉ <span>CONFIAR</span> EN NUESTRA EXPERIENCIA?</h2>
          <div class="trust-divider"></div>
          <!--<p class="trust-subtitle" id="trust_subtitle">
          Más de <strong>15 años protegiendo</strong> transacciones aeronáuticas nos avalan
        </p>-->
        </div>

        <div class="trust-grid">
          <!-- Tarjeta 1 -->
          <div class="trust-card">
            <div class="trust-badge">✓</div>
            <div class="trust-content">
              <div class="trust-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#0066CC">
                  <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-1.06 13.54l-2.12-2.12-1.41 1.41 3.53 3.53 7.07-7.07-1.41-1.41-5.66 5.66z" />
                </svg>
              </div>
              <h3 id="trust_card1_title">Expertos Reconocidos</h3>
              <p id="trust_card1_text">
                Nuestro equipo de trabajo, tiene la mejor experiencia en estos casos.
              </p>
              <div class="trust-testimonial">
                <p id="trust_card1_quote">"Gracias a su intervención por parte del equipo evitamos estafas"</p>
              </div>
            </div>
          </div>

          <!-- Tarjeta 2 -->
          <div class="trust-card">
            <div class="trust-badge">✓</div>
            <div class="trust-content">
              <div class="trust-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#0066CC">
                  <path d="M23 12l-2.44-2.78.34-3.68-3.61-.82-1.89-3.18L12 3 8.6 1.54 6.71 4.72l-3.61.81.34 3.68L1 12l2.44 2.78-.34 3.69 3.61.82 1.89 3.18L12 21l3.4 1.46 1.89-3.18 3.61-.82-.34-3.68L23 12zm-10 5h-2v-2h2v2zm0-4h-2V7h2v6z" />
                </svg>
              </div>
              <h3 id="trust_card2_title">Resultados Comprobables</h3>
              <p id="trust_card2_text">
                Hemos <strong>expuesto 47 empresas fraudulentas</strong> en los últimos 3 años, protegiendo a más de 200 clientes.
              </p>
              <div class="trust-stats">
                <div class="stat-item">
                  <span>100%</span>
                  <p id="trust_card2_stat">de casos resueltos en mediaciones</p>
                </div>
              </div>
            </div>
          </div>

          <!-- Tarjeta 3 -->
          <div class="trust-card">
            <div class="trust-badge">✓</div>
            <div class="trust-content">
              <div class="trust-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#0066CC">
                  <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm4.59-12.42L10 14.17l-2.59-2.58L6 13l4 4 8-8z" />
                </svg>
              </div>
              <h3 id="trust_card3_title">Compromiso Total</h3>
              <p id="trust_card3_text">
                Operamos bajo el principio: <strong>"Su seguridad es nuestro prestigio"</strong>. Cada cliente recibe:
              </p>
              <ul class="trust-list">
                <li id="trust_list1">Acceso directo a nuestro equipo ejecutivo</li>
                <li id="trust_list2">Reportes semanales de seguimiento</li>
                <li id="trust_list3">Garantía de confidencialidad absoluta</li>
              </ul>
            </div>
          </div>
        </div>

        <div class="trust-cta">
          <p id="trust_cta_text">¿Listo para operar con tranquilidad?</p>
          <a href="https://wa.me/19542897832" target="_blank"><button class="cta-button" id="trust_cta_btn">Hable con un especialista ahora</button></a>
        </div>
      </section>

      <!--<section class="metrics-section">
      <div class="metric-card">
        <h4 data-count="10">0</h4>
        <p id="yearsText">Años de Experiencia</p>
      </div>
      <div class="metric-card">
        <h4 data-count="12000">0</h4>
        <p id="clientsText">Clientes Protegidos</p>
      </div>
      <div class="metric-card">
        <h4 data-count="480">0</h4>
        <p id="fraudsText">Fraudes Detectados</p>
      </div>
      <div class="metric-card">
        <h4 id="visits-counter">5,247</h4>
        <p id="visitsText">Visitas Mensuales</p>
      </div>
    </section>-->
      <section class="consultation-section" id="consultas">
        <div class="section-header">
          <h2 id="solitarconsulta">SOLICITAR CONSULTA</h2>
          <div class="divider"></div>
          <p class="section-description" id="detalleconsultas">
            ¿Tienes preguntas sobre nuestros servicios? Escríbenos y te responderemos a la brevedad
          </p>
        </div>

        <div class="testimonials-container">
          <!-- Formulario de Consulta (mismo estilo que comentarios) -->
          <div class="comment-form-container">
            <h3 id="solitartexto">ENVÍANOS TU CONSULTA</h3>
            <form id="consultationForm">
              <div class="form-group">
                <input type="text" id="consult-name" name="consult-name" placeholder="Tu nombre completo" required>
              </div>
              <div class="form-group">
                <input type="tel" id="consult-phone" name="consult-phone" placeholder="Tu número de WhatsAp Ej. 59172954875" required>
              </div>
              <div class="form-group">
                <input type="email" id="consult-email" name="consult-email" placeholder="Tu correo electrónico" required>
              </div>
              <div class="form-group">
                <select id="consult-reason" name="motivo" required>
                  <option value="" disabled selected>Motivo de consulta</option>
                  <option value="Cotizacion">Cotización de servicios</option>
                  <option value="Informacion">Información general</option>
                  <option value="Tecnica">Consulta técnica</option>
                  <option value="Otro">Otro motivo</option>
                </select>
              </div>
              <div class="form-group">
                <textarea id="consult-message" name="mensaje" placeholder="Detalla tu consulta aquí..." required></textarea>
              </div>
              <button type="submit" class="submit-btn comentario">ENVIAR CONSULTA</button>
            </form>
          </div>
        </div>
      </section>
      <section class="testimonials-section trust-section" id="comentarios">
        <div class="section-header">
          <h2 id="testimonialsTitle">OPINIONES DE NUESTROS CLIENTES</h2>
          <div class="divider"></div>
          <p class="section-description" id="testimonialsDesc">
            Lo que dicen quienes han confiado en nuestros servicios de investigación aeronáutica
          </p>
        </div>

        <!-- Contenedor de los comentarios y formulario alineados -->
        <div class="testimonials-container">
          <!-- Formulario de Comentarios -->
          <div class="comment-form-container">
            <h3 id="leaveCommentTitle">DÉJANOS TU COMENTARIO</h3>
            <form id="commentForm">
              <div class="form-group">
                <input type="text" id="nombre" name="nombre" placeholder="Tu nombre" required>
              </div>
              <div class="form-group">
                <input type="text" id="cargo" name="cargo" placeholder="Tu cargo/empresa (opcional)">
              </div>
              <div class="form-group">
                <textarea id="comentario" name="comentario" placeholder="Tu experiencia con nuestros servicios" required></textarea>
              </div>
              <div class="form-group rating-group">
                <label id="ratingLabel">Calificación:</label>
                <div class="stars">
                  <input type="radio" id="star5" name="calificacion" value="5"><label for="star5">★</label>
                  <input type="radio" id="star4" name="calificacion" value="4"><label for="star4">★</label>
                  <input type="radio" id="star3" name="calificacion" value="3"><label for="star3">★</label>
                  <input type="radio" id="star2" name="calificacion" value="2"><label for="star2">★</label>
                  <input type="radio" id="star1" name="calificacion" value="1" required><label for="star1">★</label>
                </div>
              </div>
              <button type="submit" class="submit-btn comentario" id="submitBtn">ENVIAR COMENTARIO</button>
            </form>
          </div>
          <!-- Slider de Comentarios -->
          <div class="swiper">
            <div class="swiper-wrapper" id="testimonials-container">
              <!-- Los comentarios se cargarán aquí dinámicamente -->
            </div>
          </div>
        </div>
      </section>


      <!-- Modal de agradecimiento (se muestra después de enviar) -->
      <div id="thankYouModal" class="modal">
        <div class="modal-content">
          <span class="close-modal">&times;</span>
          <div class="modal-body">
            <svg viewBox="0 0 24 24" width="80" height="80" fill="#4CAF50">
              <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" />
            </svg>
            <h3 id="bscriptionModalTitle">¡GRACIAS POR TU COMENTARIO!</h3>
            <p id="subscriptionModalMessage">Tu opinión es muy valiosa para nosotros.</p>
            <button class="modal-close-btn" id="closeBtn">ENTENDIDO</button>
          </div>
        </div>
      </div>
      <footer id="contact" class="modern-footer">

        <div class="footer-container">
          <div class="footer-section">
            <div class="footer-brand">
              <a href="#" class="logos">
                <img src="img/logo.png" alt="SCAM INVESTIGATIONS AERONAUTICS" width="180">
              </a>
              <div class="social-links">
                <a href="#" aria-label="Facebook" class="social-icon">
                  <i class="ri-facebook-fill"></i>
                </a>
                <a href="#" aria-label="LinkedIn" class="social-icon">
                  <i class="ri-linkedin-fill"></i>
                </a>
                <a href="#" aria-label="Twitter" class="social-icon">
                  <i class="ri-twitter-x-line"></i>
                </a>
                <a href="#" aria-label="YouTube" class="social-icon">
                  <i class="ri-youtube-fill"></i>
                </a>
              </div>
            </div>
          </div>

          <div class="footer-section">
            <h3 class="footer-title" id="servi">Servicios</h3>
            <ul class="footer-links" id="footerServices">
              <li><a href="#">Verificación de Empresas</a></li>
              <li><a href="#">Detección de Fraudes</a></li>
              <li><a href="#">Auditorías de Seguridad</a></li>
              <li><a href="#">Mediación de Conflictos</a></li>
              <li><a href="#">Consultoría Legal</a></li>
              <li><a href="#">Escraches Públicos en Redes Sociales</a></li>
            </ul>
          </div>
          <button id="whatsappBtn" class="whatsapp-button">
            <span class="whatsapp-tooltip" id="whatsappTooltip">Presióname</span>
            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6b/WhatsApp.svg/1200px-WhatsApp.svg.png" alt="WhatsApp Icon" class="whatsapp-icon">
          </button>


          <!-- Modal de WhatsApp -->
          <div id="whatsappModal" class="modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background-color: rgba(0,0,0,0.5); justify-content: center; align-items: center;">
            <div class="modal-content" style="background-color: white; padding: 20px; border-radius: 8px;">
              <span class="close-modal cerrar" style="cursor:pointer; font-size: 24px;">&times;</span>
              <h3 id="como">¿En qué podemos ayudarte hoy?</h3>
              <textarea id="whatsappMessage" placeholder="Escribe tu mensaje..." style="width: 100%; height: 100px;"></textarea>
              <button id="sendMessageBtn">Enviar mensaje</button>
            </div>
          </div>


          <div class="footer-section">
            <h3 class="footer-title" id="cont">Contacto</h3>
            <ul class="footer-contact">
              <li>
                <i class="ri-phone-fill"></i>
                <div>
                  <span id="telf">Teléfono</span>
                  <a href="https://wa.me/19542897832" target="_blank">+ 1(954)289-7832</a>
                </div>
              </li>
              <li>
                <i class="ri-mail-fill"></i>
                <div>
                  <span>Email</span>
                  <a href="mailto:info@scaminvestigationsaeronautics.com" target="_blank">info@scaminvestigationsaeronautics.com</a>
                </div>
              </li>
            </ul>
          </div>

          <div class="footer-section">
            <h3 class="footer-title" id="boletin">Boletín Informativo</h3>
            <p class="newsletter-text" id="newsletterText">
              Suscríbete para recibir alertas sobre fraudes aeronáuticos y consejos de seguridad.
            </p>
            <br>

            <form id="subscriptionForm" class="newsletter-form">
              <div class="input-group">
                <input type="email" id="subscriberEmail" placeholder="Tu email corporativo" required>
                <button type="submit" class="submit-btn">
                  <span id="newsletterButton">Suscribirse</span>
                  <i class="ri-send-plane-fill"></i>
                </button>
              </div>
              <div class="form-message" id="formMessage"></div>
            </form>
            <h3 class="footer-title"></h3>
            <p class="privacy-text" id="privacyText">
              <i class="ri-shield-check-line"></i> Respetamos tu privacidad. No compartiremos tu información.
            </p>
          </div>
        </div>

        <div class="footer-bottom">
          <div class="footer-legal">
            <p id="legalText">&copy; 2025 SCAM INVESTIGATIONS AERONAUTICS. Todos los derechos reservados.</p>
            <div class="legal-links">
              <a href="#" id="pdfLink" target="_blank" download>Documento PDF(Descargar)</a>
              <a id="termsOfService">Términos de Servicio</a>
              <a id="privacyPolicy">Política de Privacidad</a>

            </div>
          </div>
        </div>
      </footer>
      <!-- Modal de Suscripción Exitosa -->
      <!-- Modal de Suscripción -->
      <div id="subscriptionModal" class="modal">
        <div class="modal-content">
          <div class="modal-body">
            <h3 id="subscriptionModalTitle">¡Gracias por suscribirte!</h3>
            <p id="subscriberEmailText"></p>
          </div>
        </div>
      </div>
      <script src="https://unpkg.com/scrollreveal"></script>
      <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
      <script src="main.js"></script>
      <?php
      include 'cambiaridioma_js.php';
      ?>
      <script>
        const translations = {
          es: {
            pdfDownloadText: 'Documento PDF (Descargar)',
            pdfFile: 'Investigacióndeestafas.pdf'
          },
          en: {
            pdfDownloadText: 'PDF Document (Download)',
            pdfFile: 'Scaminvestigation.pdf'
          }
        };

        document.getElementById('pdfLink').addEventListener('click', function(e) {
          const lang = localStorage.getItem('lang') || 'es';
          const langData = translations[lang];

          this.textContent = langData.pdfDownloadText;
          this.href = langData.pdfFile;
        });
        // Simulador de visitas con crecimiento inteligente
        function simulateOrganicGrowth() {
          // Cargar visitas desde localStorage o usar base inicial
          let visits = localStorage.getItem('simulatedVisits') ?
            parseInt(localStorage.getItem('simulatedVisits')) :
            config.baseVisits;

          // Calcular crecimiento diario con fluctuaciones realistas
          const dailyGrowth = Math.floor(
            config.minDailyGrowth +
            Math.random() * (config.maxDailyGrowth - config.minDailyGrowth)
          );

          // Aplicar fluctuación aleatoria (+/- 30%)
          const fluctuationFactor = 1 + (Math.random() * config.fluctuation * 2 - config.fluctuation);
          const newVisits = visits + Math.floor(dailyGrowth * fluctuationFactor);

          // Guardar para persistencia entre sesiones
          localStorage.setItem('simulatedVisits', newVisits.toString());

          return newVisits;
        }

        // Animación de contadores mejorada
        function animateCounters() {
          document.querySelectorAll('[data-count]').forEach(el => {
            const target = +el.getAttribute('data-count');
            const duration = 2000; // 2 segundos
            const steps = 30;
            const increment = target / steps;
            let count = 0;

            const timer = setInterval(() => {
              count += increment;
              if (count >= target) {
                count = target;
                clearInterval(timer);

                // Efecto final para números importantes
                if (target > 1000) {
                  el.classList.add('highlight-pulse');
                  setTimeout(() => el.classList.remove('highlight-pulse'), 1000);
                }
              }
              el.textContent = Math.floor(count).toLocaleString();
            }, duration / steps);
          });
        }
      </script>
      <script>
        document.addEventListener('DOMContentLoaded', function() {
          loadTestimonials(); // Cargar comentarios al iniciar

          // Configurar Swiper después de cargar los testimonios
          if (typeof swiper === 'undefined') {
            initSwiper();
          } else {
            swiper.update(); // Si ya está inicializado, actualízalo
          }
        });

        function loadTestimonials() {
          fetch('obtenerComentarios.php?limit=5')
            .then(response => response.json())
            .then(data => {
              const container = document.getElementById('testimonials-container');
              if (container && data.success) {
                container.innerHTML = data.comments.map(comment => `
          <div class="swiper-slide">
            <div class="client__card">
              <div class="client__content">
                <div class="client__rating">
                  ${'★'.repeat(comment.calificacion)}${'☆'.repeat(5 - comment.calificacion)}
                </div>
                <p>${comment.comentario}</p>
              </div>
              <div class="client__details">
<img src="https://www.w3schools.com/w3images/avatar2.png" alt="client" />
                <div>
                  <h4>${comment.nombre}</h4>
                  ${comment.cargo ? `<h5>${comment.cargo}</h5>` : ''}
                </div>
              </div>
            </div>
          </div>
        `).join('');
              }

              // Inicializar o actualizar Swiper
              if (typeof swiper === 'undefined') {
                initSwiper(); // Inicializa Swiper si no está definido
              } else {
                swiper.update(); // Actualiza Swiper si ya está definido
              }
            })
            .catch(error => console.error('Error loading testimonials:', error));
        }

        // Inicializa Swiper
        let swiper;

        function initSwiper() {
          swiper = new Swiper('.swiper', {
            slidesPerView: 1,
            spaceBetween: 30,
            pagination: {
              el: '.swiper-pagination',
              clickable: true,
            },
            loop: true,
          });
        }


        document.getElementById('commentForm').addEventListener('submit', submitComment);

        function submitComment(e) {
          e.preventDefault();
          const form = e.target;
          const formData = new FormData(form);

          // Validación básica adicional (por si acaso)
          const nombre = formData.get('nombre').trim();
          const comentario = formData.get('comentario').trim();
          const calificacion = formData.get('calificacion');

          if (!nombre || !comentario || !calificacion) {
            alert('Por favor, completa todos los campos requeridos.');
            return;
          }

          fetch('guardarComentario.php', {
              method: 'POST',
              body: formData
            })
            .then(response => response.json())
            .then(data => {
              if (data.success) {
                // Mostrar modal de agradecimiento
                const modal = document.getElementById('thankYouModal');
                modal.style.display = 'flex';

                // Ocultar el modal después de unos segundos (opcional)
                setTimeout(() => {
                  modal.style.display = 'none';
                }, 3000);

                form.reset(); // Limpiar formulario
                loadTestimonials(); // Recargar comentarios (función personalizada tuya)
              } else {
                alert('Error: ' + data.message);
              }
            })
            .catch(error => {
              console.error('Error al enviar comentario:', error);
              alert('Ocurrió un error al enviar tu comentario. Intenta de nuevo más tarde.');
            });
        }
      </script>
      <script>
        document.querySelectorAll('.read-more__btn').forEach(button => {
          button.addEventListener('click', () => {
            const cardId = button.getAttribute('data-card');
            const content = document.getElementById(`card-${cardId}-details`);
            const isExpanded = content.classList.contains('show');

            // Cerrar todos los demás primero
            document.querySelectorAll('.expandable__content').forEach(el => {
              el.classList.remove('show');
            });
            document.querySelectorAll('.read-more__btn').forEach(btn => {
              btn.textContent = 'Leer más +';
            });

            // Alternar el estado actual
            if (!isExpanded) {
              content.classList.add('show');
              button.textContent = 'Mostrar menos -';
            }
          });
        });
      </script>
      <script>
        const openModalBtn = document.getElementById('openModalBtn');
        const closeModalBtn = document.getElementById('closeModalBtn');
        const modalOverlay = document.getElementById('modalOverlay');

        openModalBtn.addEventListener('click', () => {
          modalOverlay.classList.add('active');
          document.body.style.overflow = 'hidden';
        });

        closeModalBtn.addEventListener('click', () => {
          modalOverlay.classList.remove('active');
          document.body.style.overflow = 'auto';
        });

        modalOverlay.addEventListener('click', (e) => {
          if (e.target === modalOverlay) {
            modalOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
          }
        });
      </script>
      <script>
        // Opcional: Scroll suave al hacer click en el indicador
        document.querySelector('.scroll-indicator').addEventListener('click', () => {
          // Asegúrate de que este selector apunte a tu contenedor de cards
          const valuesSection = document.querySelector('.values-container') ||
            document.querySelector('.cards-container') ||
            document.querySelector('.value-cards');

          if (valuesSection) {
            valuesSection.scrollIntoView({
              behavior: 'smooth'
            });
          }
        });
      </script>
      <script>
        // Efecto de movimiento 3D con el cursor
        document.querySelectorAll('.aero-card').forEach(card => {
          card.addEventListener('mousemove', (e) => {
            const rect = card.getBoundingClientRect();
            const x = e.clientX - rect.left;
            const y = e.clientY - rect.top;
            const centerX = rect.width / 2;
            const centerY = rect.height / 2;
            const angleX = (y - centerY) / 20;
            const angleY = (centerX - x) / 20;

            card.style.transform = `rotateX(${angleX}deg) rotateY(${angleY}deg) translateY(-15px)`;
          });

          card.addEventListener('mouseleave', () => {
            card.style.transform = 'translateY(-15px)';
          });
        });

        // Animación de aparición al hacer scroll
        const observer = new IntersectionObserver((entries) => {
          entries.forEach(entry => {
            if (entry.isIntersecting) {
              entry.target.style.opacity = 1;
              entry.target.style.transform = 'translateY(0)';
            }
          });
        }, {
          threshold: 0.1
        });

        document.querySelectorAll('.aero-card').forEach((card, index) => {
          card.style.opacity = 0;
          card.style.transform = 'translateY(50px)';
          card.style.transition = `all 0.7s cubic-bezier(0.22, 1, 0.36, 1) ${index * 0.15}s`;
          observer.observe(card);
        });
      </script>
      <script>
        // Configuración de crecimiento realista
        const config = {
          baseVisits: 5247,
          minDailyGrowth: 8, // Mínimo de visitas nuevas por día
          maxDailyGrowth: 25, // Máximo de visitas nuevas por día
          fluctuation: 0.3 // Variación porcentual (30%)
        };

        // Simulador de visitas con crecimiento inteligente
        function simulateOrganicGrowth() {
          // Cargar visitas desde localStorage o usar base inicial
          let visits = localStorage.getItem('simulatedVisits') ?
            parseInt(localStorage.getItem('simulatedVisits')) :
            config.baseVisits;

          // Calcular crecimiento diario con fluctuaciones realistas
          const dailyGrowth = Math.floor(
            config.minDailyGrowth +
            Math.random() * (config.maxDailyGrowth - config.minDailyGrowth)
          );

          // Aplicar fluctuación aleatoria (+/- 30%)
          const fluctuationFactor = 1 + (Math.random() * config.fluctuation * 2 - config.fluctuation);
          const newVisits = visits + Math.floor(dailyGrowth * fluctuationFactor);

          // Guardar para persistencia entre sesiones
          localStorage.setItem('simulatedVisits', newVisits.toString());

          return newVisits;
        }

        // Animación de contadores mejorada
        function animateCounters() {
          document.querySelectorAll('[data-count]').forEach(el => {
            const target = +el.getAttribute('data-count');
            const duration = 2000; // 2 segundos
            const steps = 30;
            const increment = target / steps;
            let count = 0;

            const timer = setInterval(() => {
              count += increment;
              if (count >= target) {
                count = target;
                clearInterval(timer);

                // Efecto final para números importantes
                if (target > 1000) {
                  el.classList.add('highlight-pulse');
                  setTimeout(() => el.classList.remove('highlight-pulse'), 1000);
                }
              }
              el.textContent = Math.floor(count).toLocaleString();
            }, duration / steps);
          });
        }
      </script>
      <script>
        document.addEventListener('DOMContentLoaded', function() {
          var whatsappBtn = document.getElementById("whatsappBtn");
          var modal = document.getElementById("whatsappModal");
          var closeModal = document.getElementsByClassName("close-modal cerrar")[0];
          var sendMessageBtn = document.getElementById("sendMessageBtn");
          var whatsappMessage = document.getElementById("whatsappMessage");
          var tooltip = document.querySelector(".whatsapp-tooltip");

          // Mostrar el modal cuando el botón de WhatsApp es clickeado
          whatsappBtn.onclick = function() {
            console.log("Botón de WhatsApp clickeado.");
            modal.style.display = "flex"; // Mostrar el modal
          };

          // Cerrar el modal cuando el icono de cerrar es clickeado
          closeModal.onclick = function() {
            console.log("Modal cerrado.");
            modal.style.display = "none"; // Ocultar el modal
          };

          // Cerrar el modal si se hace clic fuera del contenido del modal
          window.onclick = function(event) {
            if (event.target == modal) {
              console.log("Clic fuera del modal, cerrando...");
              modal.style.display = "none"; // Ocultar el modal
            }
          };

          // Enviar el mensaje a WhatsApp
          sendMessageBtn.onclick = function() {
            var message = whatsappMessage.value.trim();
            console.log("Mensaje a enviar:", message);
            if (message) {
              var phoneNumber = "+19542897832"; // Número de WhatsApp al que enviar el mensaje
              var url = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
              console.log("Redirigiendo a:", url); // Verifica que la URL se construye correctamente
              window.open(url, "_blank"); // Abre WhatsApp en una nueva pestaña
              modal.style.display = "none"; // Cerrar el modal después de enviar el mensaje
            } else {
              // Mostrar tooltip y enfocar el cursor en el textarea
              tooltip.textContent = "Escribe un mensaje";
              tooltip.style.display = "block";
              whatsappMessage.focus(); // Colocar el cursor en el área de texto
              setTimeout(function() {
                tooltip.style.display = "none"; // Ocultar el tooltip después de 3 segundos
              }, 3000);
            }
          };
        });

        document.addEventListener('DOMContentLoaded', function() {
          // Formulario 1 - Suscripción
          const subscriptionForm = document.getElementById('subscriptionForm');
          const subscriptionModal = document.getElementById('subscriptionModal');
          const subscriptionModalCloseBtn = document.querySelector('.modal-close-btn');
          const formMessage = document.getElementById('formMessage');

          if (subscriptionForm) {
            subscriptionForm.addEventListener('submit', function(e) {
              e.preventDefault();

              const emailInput = document.getElementById('subscriberEmail');
              const email = emailInput.value.trim();

              // Validación simple de email
              if (!email || !isValidEmail(email)) {
                formMessage.textContent = 'Por favor ingresa un email válido';
                formMessage.style.color = '#ff4444';
                return;
              }

              // Enviar datos al servidor
              fetch('guardar_suscripcion.php', {
                  method: 'POST',
                  headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                  },
                  body: `email=${encodeURIComponent(email)}`
                })
                .then(response => response.json())
                .then(data => {
                  if (data.success) {
                    // Mostrar modal de éxito
                    document.getElementById('subscriberEmailText').textContent = email;
                    subscriptionModal.style.display = 'flex'; // Mostrar el modal
                    subscriptionForm.reset();
                    formMessage.textContent = '';

                    // Cerrar el modal automáticamente después de 2 segundos
                    setTimeout(function() {
                      subscriptionModal.style.display = 'none';
                    }, 2000); // 2000 milisegundos = 2 segundos
                  } else {
                    formMessage.textContent = data.message || 'Error al procesar la suscripción';
                    formMessage.style.color = '#ff4444';
                  }
                })
                .catch(error => {
                  console.error('Error:', error);
                  formMessage.textContent = 'Error de conexión. Intenta nuevamente.';
                  formMessage.style.color = '#ff4444';
                });
            });
          }

          // Cerrar modal de suscripción cuando el usuario haga clic en el botón de cerrar
          if (subscriptionModalCloseBtn) {
            subscriptionModalCloseBtn.addEventListener('click', function() {
              subscriptionModal.style.display = 'none';
            });
          }

          // Cerrar modal si el usuario hace clic fuera del contenido del modal
          window.addEventListener('click', function(e) {
            if (e.target === subscriptionModal) {
              subscriptionModal.style.display = 'none';
            }
          });

          // Función de validación de email
          function isValidEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
          }
        });
        document.addEventListener('DOMContentLoaded', function() {
          const languageSelect = document.getElementById('languageSelect');
          const selectedOption = document.querySelector('.selected-option');
          const flagIcon = selectedOption.querySelector('.flag-icon');
          const selectedText = selectedOption.querySelector('.selected-text');

          function updateSelectedLanguage() {
            const selected = languageSelect.options[languageSelect.selectedIndex];
            const languageText = selected.textContent;
            const flagURL = selected.getAttribute('data-flag');

            selectedText.textContent = languageText;
            flagIcon.src = flagURL;
          }

          // Cambiar al seleccionar nuevo idioma
          languageSelect.addEventListener('change', () => {
            updateSelectedLanguage();

            // Aquí podrías ejecutar tu función de traducción
            // cambiarIdioma(languageSelect.value);
          });

          // Al cargar, establecer el idioma actual
          updateSelectedLanguage();
        });


        document.getElementById('consultationForm').addEventListener('submit', function(e) {
          e.preventDefault();

          if (validateConsultationForm()) {
            const btn = this.querySelector('.submit-btn');
            btn.disabled = true;
            btn.innerHTML = 'Enviando...';

            // Simular envío (reemplazar con AJAX real)
            setTimeout(() => {
              // Aquí iría tu AJAX para enviar a PHP
              sendConsultationData();

              btn.innerHTML = 'ENVIAR CONSULTA';
              btn.disabled = false;

              // Mostrar SweetAlert como en tu diseño original
              Swal.fire({
                title: '¡Consulta enviada!',
                html: 'Nos comunicaremos contigo lo antes posible directamente a tu WhatsApp y correo electrónico.',
                icon: 'success',
                timer: 4000,
                timerProgressBar: true,
                showConfirmButton: false
              });

              this.reset();
            }, 1500);
          }
        });

        function validateConsultationForm() {
          let isValid = true;
          const form = document.getElementById('consultationForm');

          // Validar cada campo
          const requiredFields = form.querySelectorAll('[required]');
          requiredFields.forEach(field => {
            const formGroup = field.closest('.form-group');

            if (!field.value.trim()) {
              formGroup.classList.add('invalid');
              const errorMsg = formGroup.querySelector('.error-message') || document.createElement('span');
              if (!formGroup.querySelector('.error-message')) {
                errorMsg.className = 'error-message';
                formGroup.appendChild(errorMsg);
              }
              errorMsg.textContent = 'Este campo es requerido';
              isValid = false;
            } else {
              formGroup.classList.remove('invalid');
            }

            // Validación específica para email
            if (field.type === 'email' && field.value.trim()) {
              const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
              if (!emailRegex.test(field.value)) {
                field.closest('.form-group').classList.add('invalid');
                field.closest('.form-group').querySelector('.error-message').textContent = 'Ingresa un email válido';
                isValid = false;
              }
            }


          });

          return isValid;
        }

        function sendConsultationData() {
          const btn = document.querySelector('#consultationForm .submit-btn');
          const originalBtnText = btn.innerHTML;
          btn.disabled = true;
          btn.innerHTML = '<span class="loader"></span> Enviando...';

          const formData = new FormData(document.getElementById('consultationForm'));

          fetch('send_consultation.php', {
              method: 'POST',
              body: formData
            })
            .then(async response => {
              if (!response.ok) {
                const errorData = await response.json().catch(() => null);
                throw new Error(errorData?.error || `Error HTTP: ${response.status}`);
              }
              return response.json();
            })
            .then(data => {
              if (data.success) {
                Swal.fire({
                  title: translations.successTitle || '¡Éxito!',
                  text: translations.successText || 'Tu consulta ha sido enviada correctamente.',
                  icon: 'success',
                  timer: 4000,
                  showConfirmButton: false
                });
                document.getElementById('consultationForm').reset();
              } else {
                showFormErrors(data.errors || {
                  general: translations.errorProcessing || 'Error al procesar la solicitud'
                });
              }
            })
            .catch(error => {
              console.error('Error:', error);
              Swal.fire({
                title: translations.errorTitle || 'Error',
                text: error.message || translations.errorConnection || 'Error al conectar con el servidor',
                icon: 'error'
              });
            })
            .finally(() => {
              btn.disabled = false;
              btn.innerHTML = originalBtnText;
            });
        }

        function showFormErrors(errors) {
          // Limpiar errores anteriores
          document.querySelectorAll('.error-message').forEach(el => el.remove());
          document.querySelectorAll('.form-group').forEach(el => el.classList.remove('invalid'));

          // Mostrar nuevos errores
          Object.entries(errors).forEach(([field, message]) => {
            const input = document.querySelector(`[name="${field}"]`);
            if (input) {
              const formGroup = input.closest('.form-group');
              formGroup.classList.add('invalid');

              const errorMsg = document.createElement('span');
              errorMsg.className = 'error-message';
              errorMsg.textContent = message;
              formGroup.appendChild(errorMsg);
            } else {
              // Error general (no asociado a un campo específico)
              Swal.fire({
                title: 'Error',
                text: message,
                icon: 'error'
              });
            }
          });
        }
      </script>
    </div>
  </div>
</body>

</html>