<?php
header('Content-Type: application/json');

// Mostrar errores (solo para desarrollo)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Configuración de la base de datos
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "aviacionpagina";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexión
if ($conn->connect_error) {
    echo json_encode([
        'success' => false,
        'message' => 'Connection failed: ' . $conn->connect_error
    ]);
    exit;
}

// Obtener límite de comentarios (predeterminado: 5)
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 5;

// Consulta SQL: obtener comentarios aprobados
$sql = "SELECT nombre, cargo, comentario, calificacion, fecha 
        FROM comentarios 
        WHERE aprobado = 0 
        ORDER BY fecha DESC 
        LIMIT ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $limit);
$stmt->execute();
$result = $stmt->get_result();

$comments = [];
while ($row = $result->fetch_assoc()) {
    $comments[] = $row;
}

echo json_encode([
    'success' => true,
    'comments' => $comments
]);

$conn->close();
